clear all; close all; clc

load('D50_a.mat');
load('D50_b.mat');
load('D100_a.mat');
load('D100_b.mat');
load('D200_a.mat');
load('D200_b.mat');



Tb1_monthly_avg=[Tb1_monthly_avg_a' Tb1_monthly_avg_b Tb1_monthly_avg_c];
Tb1_std=[Tb1_std_a' Tb1_std_b Tb1_std_c]; 

Tf1_monthly_avg=[Tf1_monthly_avg_a' Tf1_monthly_avg_b Tf1_monthly_avg_c];
Tf1_std=[Tf1_std_a' Tf1_std_b Tf1_std_c]; 


figure(1)
subplot(2,1,1)
errorbar(1:12, Tb1_monthly_avg, Tb1_std, 'o-', 'LineWidth', 1.5);
legend('k_g = 2.7 W/mK', 'k_g = 3.1 W/mK', 'k_g = 3.5 W/mK');
set(gca,'fontsize',25)
grid on;
title('Temperature profile (Borehole)');
xlabel('Time (month)');
ylabel('Temperature (°C)');

subplot(2,1,2)
errorbar(1:12, Tf1_monthly_avg, Tf1_std, 'o-', 'LineWidth', 1.5);
legend('k_g = 2.7 W/mK', 'k_g = 3.1 W/mK', 'k_g = 3.5 W/mK');
set(gca,'fontsize',25)
grid on;
title('Temperature profile (Fluid)');
xlabel('Time (month)');
ylabel('Temperature (°C)');